﻿namespace Code6587EN.Ch07.Controls
{
    using Microsoft.SharePoint;
    using Microsoft.SharePoint.Utilities;
    using System.Globalization;
    using System.Web.UI;

    /// <summary>
    /// ASP.NET user control to add meta tags to the page when the current item contains the associated
    /// fields.
    /// </summary>
    public class CustomMetaTags : UserControl
    {
        // Name of the list item field for the keywords
        private const string FieldNameKeywords = "Meta Keywords";
        
        // Name of the list item field for the description
        private const string FieldNameDescription = "Meta Description";

        // Formats to render the meta tags on the page with
        private const string FormatMetaTagKeywords = "<meta name=\"keywords\" content=\"{0}\" />";
        private const string FormatMetaTagDescription = "<meta name=\"description\" content=\"{0}\" />";

        // Override the CreateChildControls method to add our meta tags to the page
        protected override void CreateChildControls()
        {
            // Wrap the code in an SPMonitoredScope
            // http://msdn.microsoft.com/en-us/library/ff512758(v=office.14).aspx
            using (new SPMonitoredScope("Code6587EN.Ch07.Controls.CustomMetaTags::CreateChildControls"))
            {
                // Ensure the current SharePoint context contains a file and an associated list item
                if (SPContext.Current != null
                    && SPContext.Current.File != null
                    && SPContext.Current.File.Item != null)
                {
                    // Get the list item associated with the current file (page)
                    var item = SPContext.Current.File.Item;

                    // If the list contains the keywords field and it has a value, render
                    // the meta tag on the page with its content
                    if (item.Fields.ContainsField(FieldNameKeywords)
                        && item[FieldNameKeywords] != null
                        && !string.IsNullOrEmpty(item[FieldNameKeywords].ToString()))
                        this.Controls.Add(new LiteralControl(
                            string.Format(CultureInfo.InvariantCulture,
                            FormatMetaTagKeywords,
                            item[FieldNameKeywords].ToString())));

                    // If the list contains the description field and it has a value, render
                    // the meta tag on the page with its content
                    if (item.Fields.ContainsField(FieldNameDescription)
                        && item[FieldNameDescription] != null
                        && !string.IsNullOrEmpty(item[FieldNameDescription].ToString()))
                        this.Controls.Add(new LiteralControl(
                            string.Format(CultureInfo.InvariantCulture,
                            FormatMetaTagDescription,
                            item[FieldNameDescription].ToString())));
                }
            }
        }
    }
}
